/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.james.tinkerscalibration.TinkersCalibrationArmorModifiers;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ReduceToolDamageModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ArmorIgneousModifier
extends Modifier
implements ToolDamageModifierHook,
AttributesModifierHook {
    private static final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "igneous_mod");
    private static final TinkerDataCapability.TinkerDataKey<Integer> IGNEOUS = TConstruct.createKey((String)"igneous_armor");

    public ArmorIgneousModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorIgneousModifier::onUpdateApply);
    }

    private static void onUpdateApply(LivingEvent.LivingTickEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && !living.f_19853_.f_46443_ && living.m_6084_()) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                IToolStackView patt4698$temp;
                IToolStackView patt4051$temp;
                IToolStackView patt3403$temp;
                ModDataNBT persistentData;
                ToolStack tool;
                IToolStackView patt2756$temp = context.getToolInSlot(EquipmentSlot.LEGS);
                if (patt2756$temp instanceof ToolStack) {
                    tool = (ToolStack)patt2756$temp;
                    persistentData = tool.getPersistentData();
                    int level = tool.getModifierLevel(TinkersCalibrationArmorModifiers.igneous.get());
                    if (level > 0 && persistentData.getFloat(KEY) <= (float)(5 * level) && living.m_6060_() && RANDOM.nextFloat() <= (float)level * 0.6f && living.f_19797_ % 100 == 0) {
                        persistentData.putFloat(KEY, persistentData.getFloat(KEY) + 0.1f);
                    }
                }
                if ((patt3403$temp = context.getToolInSlot(EquipmentSlot.HEAD)) instanceof ToolStack) {
                    tool = (ToolStack)patt3403$temp;
                    persistentData = tool.getPersistentData();
                    int level = tool.getModifierLevel(TinkersCalibrationArmorModifiers.igneous.get());
                    if (level > 0 && persistentData.getFloat(KEY) <= (float)(5 * level) && living.m_6060_() && RANDOM.nextFloat() <= (float)level * 0.6f && living.f_19797_ % 100 == 0) {
                        persistentData.putFloat(KEY, persistentData.getFloat(KEY) + 0.1f);
                    }
                }
                if ((patt4051$temp = context.getToolInSlot(EquipmentSlot.CHEST)) instanceof ToolStack) {
                    tool = (ToolStack)patt4051$temp;
                    persistentData = tool.getPersistentData();
                    int level = tool.getModifierLevel(TinkersCalibrationArmorModifiers.igneous.get());
                    if (level > 0 && persistentData.getFloat(KEY) <= (float)(5 * level) && living.m_6060_() && RANDOM.nextFloat() <= (float)level * 0.6f && living.f_19797_ % 100 == 0) {
                        persistentData.putFloat(KEY, persistentData.getFloat(KEY) + 0.1f);
                    }
                }
                if ((patt4698$temp = context.getToolInSlot(EquipmentSlot.FEET)) instanceof ToolStack) {
                    tool = (ToolStack)patt4698$temp;
                    persistentData = tool.getPersistentData();
                    int level = tool.getModifierLevel(TinkersCalibrationArmorModifiers.igneous.get());
                    if (level > 0 && persistentData.getFloat(KEY) <= (float)(5 * level) && living.m_6060_() && RANDOM.nextFloat() <= (float)level * 0.6f && living.f_19797_ % 100 == 0) {
                        persistentData.putFloat(KEY, persistentData.getFloat(KEY) + 0.1f);
                    }
                }
            });
        }
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.ATTRIBUTES, ModifierHooks.TOOL_DAMAGE);
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(IGNEOUS, false, null));
    }

    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(KEY, 5)) {
            int level;
            float value = persistentData.getFloat(KEY);
            if (value >= (float)(level = modifier.getLevel()) / 5.0f) {
                return ReduceToolDamageModule.reduceDamage((int)amount, (float)((float)(0.1 * (double)level)));
            }
            return ReduceToolDamageModule.reduceDamage((int)amount, (float)(value / 10.0f));
        }
        return amount;
    }

    public boolean isArmor(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        float current;
        if (this.isArmor(slot) && (current = tool.getPersistentData().getFloat(KEY)) != 0.0f) {
            consumer.accept(Attributes.f_22284_, new AttributeModifier(UUID.fromString("115d9b72-da0c-4395-bfab-2f2287d6d1eb"), Attributes.f_22284_.m_22087_(), (double)current, AttributeModifier.Operation.ADDITION));
            consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("93bdef84-fac5-4445-90b6-fed434adcdfe"), Attributes.f_22285_.m_22087_(), (double)current, AttributeModifier.Operation.ADDITION));
            consumer.accept(Attributes.f_22278_, new AttributeModifier(UUID.fromString("fdcd922f-7891-4d6f-bf61-226e85c1b174"), Attributes.f_22278_.m_22087_(), (double)current, AttributeModifier.Operation.ADDITION));
        }
    }
}

